<?php

namespace VM\ApiBundle\Command;

use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\Application;
use VM\ApiBundle\Entity\Method;
use VM\ApiBundle\Entity\Service;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Services\PasswordEncoder;

class CreateNewServiceCommand extends ContainerAwareCommand
{
    /**
     * @var OutputInterface
     */
    private $output;

    /**
     * @var InputInterface
     */
    private $input;


    private $dialog;


    protected function configure()
    {
        $this
            ->setName('sso:create:service')
            ->setDescription('Stworzenie nowego serwisu')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try
        {
            $this->output = $output;
            $this->input = $input;
            $this->dialog = $this->getHelperSet()->get('dialog');
            $output->writeln('<bg=green;options=bold>Create new service</bg=green;options=bold> ');

            $name = '';
            $this->setValue($name, 'Name');

            $methodsIds = $this->writeMethodList();

            $Service = $this->createService($name);
            $this->addMethodsToService($Service,$methodsIds);

            $this->getEntityManager()->flush();
            $this->refreshService($Service);

            $this->writeServiceData($Service);
        }
        catch(\Exception $Exception)
        {
            $output->writeln('<error>' . $Exception->getCode() . ' - ' . $Exception->getMessage() .  ' </error>');
        }
    }

    private function writeMethodList()
    {
        $this->output->writeln('Methods list:');
        $this->output->writeln('0 - All(Wybierz wszystie dostepne metody)');
        $Methods = $this->getEntityManager()->getRepository('VMApiBundle:Method')->findAll();
        /** @var Method $Method */
        foreach($Methods as $Method)
        {
            $this->output->writeln($Method->getId().' - '.$Method->getSymbol().' ('.$Method->getDescription().')');
        }

        $methodsIds = '';
        $this->setValue($methodsIds, 'Choose method ids',1);

        $methodsIds = explode(',',$methodsIds);

        return $methodsIds;
    }

    private function writeServiceData(Service $Service)
    {
        $this->output->writeln('<bg=green;options=bold>Data:</bg=green;options=bold> ');
        $this->output->writeln('Name    : '.$Service->getName());
        $this->output->writeln('Appkey  : '.$Service->getAppKey());
        $this->output->write('Methods : ');
        /** @var Method $Method */
        foreach($Service->getMethods() as $Method)
        {
            $this->output->write($Method->getSymbol().',');
        }
        $this->output->writeln('');
    }

    /**
     * @param $name
     * @return Service
     */
    private function createService($name)
    {
        $Service = new Service();
        $Service->setName($name);
        $Service->setAppKey(md5($name));
        $this->getEntityManager()->persist($Service);

        return $Service;
    }

    private function refreshService(Service &$Service)
    {
        $this->getEntityManager()->refresh($Service);
        $serviceId = $Service->getId();
        $this->getEntityManager()->clear();

        return $Service = $this->getEntityManager()->getRepository('VMApiBundle:Service')->find($serviceId);
    }

    private function addMethodsToService(Service $Service,$methodsIds)
    {
        $Methods = $Methods = $this->getEntityManager()->getRepository('VMApiBundle:Method')->findAll();
        foreach($Methods as $Method)
        {
            if(in_array((string)$Method->getId(),$methodsIds) || in_array('0',$methodsIds))
            {
                $Service->addMethod($Method);
                $Method->addService($Service);
            }
        }
    }

    private function setValue(&$value,$description, $minLength = 3)
    {
        $error = false;
        do
        {
            if(strlen($value) < 3 && $error)
            {
                $this->output->writeln('Min '.$minLength.' char.');
            }
            $value = $this->dialog->ask($this->output,$description.': ');
            $error = true;
        }
        while (strlen($value) < $minLength);

        return $value;
    }

    /**
     * @return EntityManager
     */
    private function getEntityManager()
    {
        return $this->getContainer()->get('doctrine.orm.entity_manager');
    }
} 